<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreForm extends VisualizzatoreComponente {
        private $gestoreTraduzioni;
        private $linguaCorrente;
        
        function __construct($db) {
            parent::__construct($db);
        }

        function generaContenutoSezione($dati) {
            $impostazioniForm         = parent::getDb()->leggiSingolaRiga("geec_form",$dati["idElemento"]);
            $impostazioniAspetto      = recuperaImpostazioni(parent::getDb());
            $paginaRingraziamento     = parent::getDb()->leggiSingolaRiga("geecB_contenuti",$impostazioniForm["paginaRingraziamento"]);
            if($paginaRingraziamento) { // se la pagina ringraziamento è stata impostata calcola il link
                $linkPaginaRingraziamento = GeneratoreUrl::creaUrlContenuto($paginaRingraziamento, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]);
            }
            else {
                $linkPaginaRingraziamento = "";
            }
            
            if($impostazioniForm["azione"]=="Invia email") {
                $operazione = "inviaEmail";
                $action     = "";
            }
            else if($impostazioniForm["azione"]=="Inserisci utente in Geecom Admin") {
                $operazione = "creaUtenteEInviaMail";
                $action     = "";
            }
            else if($impostazioniForm["azione"]=="Invio a script personalizzato") {
                $operazione = "inserisciDatoInvio";
                $action     = "action=\"{$impostazioniForm["linkScriptEsterno"]}\" method=\"post\"";
            }
            else if($impostazioniForm["azione"]=="Usa come form ricerca") {
                $operazione = ($impostazioniForm["usaAjax"]!="si") ? "eseguiRicerca" : "eseguiRicercaAjax";
                $action     = ($impostazioniForm["usaAjax"]!="si") ? "action=\"{$impostazioniForm["linkScriptRicerca"]}\" method=\"get\"" : "";
            }
            
            if($impostazioniForm["formInLinea"]=="si") {
                $this->stampaFormInLinea($impostazioniForm,$dati,$linkPaginaRingraziamento,$operazione,$action);
            }
            else {
                $this->stampaForm($impostazioniForm,$dati,$linkPaginaRingraziamento,$operazione,$action);
            }
        }
        
        function stampaForm($impostazioniForm,$dati,$linkPaginaRingraziamento,$operazione,$action) {
            
            echo "<div class=\"{$impostazioniForm["spazioOccupato"]}\">";
                    $this->stampaTitolo($impostazioniForm);
                    echo"<form name=\"form{$impostazioniForm["id"]}\" id=\"form{$impostazioniForm["id"]}\" $action class=\"mb-5\">";
                    ?>
                    <div class="row">
                        <?php $this->stampaElementiForm($dati,$impostazioniForm); ?>

                        <div class="col-12">
                            <?php
                                if($impostazioniForm["spuntaPrivacy"]) {
                            ?>
                                    <div class="custom-control custom-checkbox my-3 mr-sm-2">
                                        <input type="checkbox" id="accettazioneTerminiCondizioni" value="si" class="custom-control-input"> 
                                        <label class="custom-control-label" for="accettazioneTerminiCondizioni">
                                            <?= $this->gestoreTraduzioni->traduci("Accetto le",$this->linguaCorrente) ?> <a href="<?= $impostazioniForm["linkPrivacy"] ?>" target=\"_blank\"><?= $this->gestoreTraduzioni->traduci("Condizioni sulla privacy",$this->linguaCorrente) ?></a>
                                        </label>
                                    </div>
                            <?php
                                }

                                if($impostazioniForm["noteAggiuntive"]!="") {
                                    ?>   
                                        <div class="mt-3 mt-md-0 mb-3"><?= $impostazioniForm["noteAggiuntive"] ?></div>
                                    <?php
                                }
                            ?>
                        </div>

                        <div class="<?= $impostazioniForm["spazioOccupatoPulsante"] ?>">
                            <?php 
                                $classeAggiuntivaIcona = ($impostazioniForm["iconaPulsante"]!="") ? "ml-2" : "";
                                echo "<button type=\"button\" id=\"pulsanteForm{$impostazioniForm["id"]}\" class=\"btn btn-lg btn-primary btn-block\" onclick=\"inviaDatiForm({$impostazioniForm["id"]},'{$impostazioniForm["spuntaPrivacy"]}','$linkPaginaRingraziamento','$operazione')\">{$impostazioniForm["etichettaPulsante"]}<i class=\"{$impostazioniForm["iconaPulsante"]} $classeAggiuntivaIcona\"></i></button>";
                            ?>
                        </div>
                    </div>
                    
                    <?php
                        if($impostazioniForm["azione"]=="Usa come form ricerca") {
                    ?>
                            <div id="divEsitoRicerca"></div>
                    <?php
                        }
                    ?>
                </form>
            </div>
        <?php
            $this->impostaJavascriptAssociato($impostazioniForm);
        }

        function stampaFormInLinea($impostazioniForm,$dati,$linkPaginaRingraziamento,$operazione,$action) {
            ?>
            <div class="<?= $impostazioniForm["spazioOccupato"] ?>">
                <?php $this->stampaTitolo($impostazioniForm) ?>
                <form name="form<?= $impostazioniForm["id"] ?>" id="form<?= $impostazioniForm["id"] ?>" <?= $action ?> class="mb-5">
                
                <div class="form-row">
                    <?php $this->stampaElementiForm($dati,$impostazioniForm); ?>

                    <div class="<?= $impostazioniForm["spazioOccupatoPulsante"] ?>">
                        <?php 
                            $classeAggiuntivaIcona = ($impostazioniForm["iconaPulsante"]!="") ? "ml-2" : "";
                            echo "<button type=\"button\" id=\"pulsanteForm{$impostazioniForm["id"]}\" class=\"btn btn-lg btn-primary btn-block\" onclick=\"inviaDatiForm({$impostazioniForm["id"]},'{$impostazioniForm["spuntaPrivacy"]}','$linkPaginaRingraziamento','$operazione')\">{$impostazioniForm["etichettaPulsante"]}<i class=\"{$impostazioniForm["iconaPulsante"]} $classeAggiuntivaIcona\"></i></button>";
                        ?>
                    </div>
                </div>
                <?php
                    if($impostazioniForm["spuntaPrivacy"]) {
                ?>
                        <div class="custom-control custom-checkbox my-3 mr-sm-2">
                            <input type="checkbox" id="accettazioneTerminiCondizioni" value="si" class="custom-control-input"> 
                            <label class="custom-control-label" for="accettazioneTerminiCondizioni">
                                <?= $this->gestoreTraduzioni->traduci("Accetto le",$this->linguaCorrente) ?> <a href="<?= $impostazioniForm["linkPrivacy"] ?>" target=\"_blank\"><?= $this->gestoreTraduzioni->traduci("Condizioni sulla privacy",$this->linguaCorrente) ?></a>
                            </label>
                        </div>
                <?php
                    }

                    if($impostazioniForm["azione"]=="Usa come form ricerca") {
                ?>
                        <div id="divEsitoRicerca"></div>
                <?php
                    }
                    
                    if($impostazioniForm["noteAggiuntive"]!="") {
                        ?>   
                            <div class="mt-3 mt-md-0 mb-3"><?= $impostazioniForm["noteAggiuntive"] ?></div>
                        <?php
                    }
                ?>
                </form>
            </div>
            <?php
            
            $this->impostaJavascriptAssociato($impostazioniForm);
        }
        
        function stampaElementiForm($dati,$impostazioniForm) {
            $query = "SELECT * FROM geec_elementiForm WHERE idForm = {$dati["idElemento"]} ORDER BY posizione ASC";
            $ris   = parent::getDb()->eseguiQueryLettura($query);
            while($elemento = $ris->fetch_assoc()) {
                $campoObblicatorio = ($elemento["obbligatorio"]=="si") ? " *" : "";
                $stringaRequired   = ($elemento["obbligatorio"]=="si") ? " required" : "";
                if($elemento["tipo"]=="Testo") {
                    ?>
                    <div class="<?= $elemento["spazioOccupato"] ?>">
                        <?php
                            GeneratoreForm::stampaInputTestuale($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],$elemento["valore"],$stringaRequired,true,"form-label-group");
                        ?>
                    </div>
                    <?php
                }
                else if($elemento["tipo"]=="Email") {
                    ?>
                    <div class="<?= $elemento["spazioOccupato"] ?>">
                        <?php
                            GeneratoreForm::stampaInputEmail($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],$elemento["valore"],$stringaRequired,"form-label-group");
                        ?>
                        </div>
                    <?php
                }
                else if($elemento["tipo"]=="Area testo") {
                    ?>
                    <div class="<?= $elemento["spazioOccupato"] ?>">
                        <?php
                            GeneratoreForm::stampaAreaTesto($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio,$elemento["placeholder"],$elemento["valore"],10,0,$stringaRequired,"form-label-group");
                        ?>
                    </div>
                    <?php
                }
                else if($elemento["tipo"]=="Password") {
                    ?>
                    <div class="<?= $elemento["spazioOccupato"] ?>">
                        <?php
                            GeneratoreForm::stampaInputPassword($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],"form-label-group");
                        ?>
                    </div>
                    <?php
                }
                else if($elemento["tipo"]=="Tendina") {
                    ?>
                    <div class="<?= $elemento["spazioOccupato"] ?>">
                        <?php
                            $opzioniTendina = explode(",",$elemento["opzioni"]);
                            GeneratoreForm::stampaSelect($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $opzioniTendina,$elemento["valore"], "form-group");
                        ?>
                    </div>
                    <?php
                }
                else if($elemento["tipo"]=="Checkbox") {
                    ?>
                    <div class="<?= $elemento["spazioOccupato"] ?>">
                        <?php
                            GeneratoreForm::stampaInputCheckbox($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["valore"], "custom-control custom-checkbox my-3","custom-control-input", $stringaRequired);
                        ?>
                    </div>
                    <?php
                }
                else if($elemento["tipo"]=="Radio") {
                    ?>
                    <div class="<?= $elemento["spazioOccupato"] ?>">
                        <?php
                            GeneratoreForm::stampaInputCheckbox($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],"form-label-group");
                        ?>
                    </div>
                    <?php
                }
                else if($elemento["tipo"]=="Data") {
                    ?>
                    <div class="<?= $elemento["spazioOccupato"] ?>">
                        <?php
                            GeneratoreForm::stampaInputData($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],$elemento["valore"],$stringaRequired,"form-label-group");
                        ?>
                    </div>
                    <?php
                }
                else if($elemento["tipo"]=="Orario") {
                    ?>
                    <div class="<?= $elemento["spazioOccupato"] ?>">
                        <?php
                            GeneratoreForm::stampaInputOrario($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],$elemento["valore"],$stringaRequired,"form-label-group");
                        ?>
                    </div>
                    <?php
                }
                else if($elemento["tipo"]=="Codice univoco") {
                	$valoreCampo = uniqid();
                    ?>
                    <div class="<?= $elemento["spazioOccupato"] ?>">
                        <?php
                            GeneratoreForm::stampaInputTestuale($elemento["nome"], $elemento["nome"], $elemento["etichetta"].$campoObblicatorio, $elemento["placeholder"],$valoreCampo,$stringaRequired,true,"form-label-group");
                        ?>
                    </div>
                    <?php
                }
            }
            
            if($impostazioniForm["stampaLinkPaginaForm"]=="si") {
                $linkPaginaForm = $_SERVER["REQUEST_URI"];
                GeneratoreForm::stampaInputNascosto("Pagina web", $linkPaginaForm);
            }
        }
        
        function stampaTitolo($impostazioniForm) {
            if($impostazioniForm["mostraTitoloComponente"]=="si") {
                ?>
                <h2 class="separatore-inferiore text-center"><?= $impostazioniForm["nome"] ?></h2>
                <?php
            }
        }
        
        function impostaJavascriptAssociato($impostazioniForm) {
            $query = "SELECT * FROM geec_elementiForm WHERE idForm = {$impostazioniForm["id"]} ORDER BY posizione ASC";
            $ris   = parent::getDb()->eseguiQueryLettura($query);
            $recuperoDati 	 = "";
            $elementiDaTrasmettere = "";
            while($elementoForm = $ris->fetch_assoc()) {
                $recuperoDati .= "var {$elementoForm["nome"]} = document.getElementById(\"{$elementoForm["nome"]}\").value;\n";
                $elementiDaTrasmettere .= "{$elementoForm["nome"]}:{$elementoForm["nome"]},\n";
            }
            
            if($impostazioniForm["azione"]=="Usa come form ricerca") {
                
                $codiceJavascript = "<script>
                        function eseguiRicercaAjax() {
                            $recuperoDati
                            $.ajax({
                                type:\"POST\",
                                url:\"{$impostazioniForm["linkScriptRicerca"]}\",
                                data:{
                                    operazione:\"ricercaPersonalizzata\",
                                    $elementiDaTrasmettere
                                },
                                success:function(esitoRicerca) {
                                    $(\"#divEsitoRicerca\").html(esitoRicerca);
                                },
                                error: function() {
                                    alert(\"Si sono verificato problemi durante la richiesta, riprova tra qualche istante\");
                                }
                            });
                        }
                    </script>";
                parent::setJavascriptAssociato($codiceJavascript);
            }
            else if($impostazioniForm["azione"]=="Inserisci utente in Geecom Admin") {
                $impostazioniAdmin = parent::getDb()->leggiSingolaRiga("geecAd_impostazioni",1);
                $arrayUrlAdmin     = explode("/",$impostazioniAdmin["urlPiattaforma"]);
                $cartellaAdmin     = $arrayUrlAdmin[count($arrayUrlAdmin)-1];
                $codiceJavascript = "<script>
                        function creaUtenteInGeecomAdmin() {
                            $recuperoDati
                            $.ajax({
                                type:\"POST\",
                                url:\"$cartellaAdmin/controller/controllerUtenti.php\",
                                async:false,
                                data:{
                                    operazione:\"creaUtenteEInviaMail\",
                                    $elementiDaTrasmettere
                                },
                                success:function(idUtente) {
                                    if(isNaN(idUtente)) { // se il dato restituito non è un numero è un errore, quindi lo mostra a video
                                        alert(idUtente);
                                    }
                                },
                                error: function() {
                                    alert(\"Si sono verificato problemi durante la richiesta, riprova tra qualche istante\");
                                }
                            });
                        }
                    </script>";
                parent::setJavascriptAssociato($codiceJavascript);
            }
        }
        
        // getter & setter
        public function getGestoreTraduzioni() {
            return $this->gestoreTraduzioni;
        }

        public function getLinguaCorrente() {
            return $this->linguaCorrente;
        }

        public function setGestoreTraduzioni($gestoreTraduzioni): void {
            $this->gestoreTraduzioni = $gestoreTraduzioni;
        }

        public function setLinguaCorrente($linguaCorrente): void {
            $this->linguaCorrente = $linguaCorrente;
        }

    }
